// ---------------------------------------------------------------------------------------
//  RTC.C - RTC (Real Time Clock / RICOH RP5C15)
// ---------------------------------------------------------------------------------------

#include "../win32/common.h"
#include "mfp.h"

BYTE	RTC_Regs[2][16];
BYTE	RTC_Bank = 0;
static int RTC_Timer1 = 0;
static int RTC_Timer16 = 0;


void Save_RTC( FILE *fp )
{
	fwrite( RTC_Regs, 1, sizeof(RTC_Regs), fp );
	fwrite( &RTC_Bank, 1, sizeof(RTC_Bank), fp );
	fwrite( &RTC_Timer1, 1, sizeof(RTC_Timer1), fp );
	fwrite( &RTC_Timer16, 1, sizeof(RTC_Timer16), fp );
}

void Load_RTC( FILE *fp )
{
	fread( RTC_Regs, 1, sizeof(RTC_Regs), fp );
	fread( &RTC_Bank, 1, sizeof(RTC_Bank), fp );
	fread( &RTC_Timer1, 1, sizeof(RTC_Timer1), fp );
	fread( &RTC_Timer16, 1, sizeof(RTC_Timer16), fp );
}


// -----------------------------------------------------------------------
//   
// -----------------------------------------------------------------------
void RTC_Init(void)
{
	ZeroMemory(&RTC_Regs[1][0], 16);
	RTC_Regs[0][13] = 0;
	RTC_Regs[0][14] = 0;
	RTC_Regs[0][15] = 0x0c;
}


// -----------------------------------------------------------------------
//   Ƃ̂[
// -----------------------------------------------------------------------
BYTE FASTCALL RTC_Read(DWORD adr)
{
	BYTE ret = 0;
	SYSTEMTIME t;
	GetLocalTime(&t);

	adr &= 0x1f;
	if (!(adr&1)) return 0;
	if (RTC_Bank == 0)
	{
		switch(adr)
		{
		case 0x01: ret=(t.wSecond)%10; break;
		case 0x03: ret=(t.wSecond)/10; break;
		case 0x05: ret=(t.wMinute)%10; break;
		case 0x07: ret=(t.wMinute)/10; break;
		case 0x09: ret=(t.wHour)%10; break;
		case 0x0b: ret=(t.wHour)/10; break;
		case 0x0d: ret=(BYTE)(t.wDayOfWeek); break;
		case 0x0f: ret=(t.wDay)%10; break;
		case 0x11: ret=(t.wDay)/10; break;
		case 0x13: ret=(t.wMonth)%10; break;
		case 0x15: ret=(t.wMonth)/10; break;
		case 0x17: ret=((t.wYear)-1980)%10; break;
		case 0x19: ret=(((t.wYear)-1980)/10)&15; break;
		case 0x1b: ret=RTC_Regs[0][13]; break;
		case 0x1d: ret=RTC_Regs[0][14]; break;
		case 0x1f: ret=RTC_Regs[0][15]; break;
		}
	}
	else
	{
		if (adr == 0x1b)
			ret = (RTC_Regs[1][13]|1);
		else if (adr == 0x17)
			ret = ((t.wYear)-1980)%4;
		else
			ret = RTC_Regs[1][adr>>1];
	}
	return ret;
}


// -----------------------------------------------------------------------
//   炢
// -----------------------------------------------------------------------
void FASTCALL RTC_Write(DWORD adr, BYTE data)
{
	if ( adr==0xe8a001 ) {
//		RTC_Timer1  = 0;
//		RTC_Timer16 = 0;
	} else if ( adr==0xe8a01b ) {
		RTC_Regs[0][13] = RTC_Regs[1][13] = data&0x0c;		// Alarm/Timer Enable
	} else if ( adr==0xe8a01f ) {
		RTC_Regs[0][15] = RTC_Regs[1][15] = data&0x0c;		// Alarm[qo͐
	}
}


void RTC_Timer(int clock)
{
	RTC_Timer1  += clock;
	RTC_Timer16 += clock;
	if ( RTC_Timer1>=10000000 ) {
		if ( !(RTC_Regs[0][15]&8) ) MFP_Int(15);
		RTC_Timer1 -= 10000000;
	}
	if ( RTC_Timer16>=625000 ) {
		if ( !(RTC_Regs[0][15]&4) ) MFP_Int(15);
		RTC_Timer16 -= 625000;
	}
}
